//
//  ABPerson+BIAdditions.h
//  BISubstrate
//
//  Created by Ali Lalani on 25/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AddressBook/AddressBook.h>
@class MCUserDefaults;

#ifdef BILLINGS_PRO
@class BIIdentity;
#endif

/*!
    @header ABPerson+BIAdditions
    @abstract   Category which provides functionality commonly needed on ABPerson for Billings.
    @discussion We have added methods which simply wrap alot of Address Book functionality to give us easier ways to interact with ABPersons.  Some methods will take many ABPerson fields to give us a complete Address or a Full name.  Basically we are just abstracting out dealing with the ABPerson fields directly for the most part, and much of it helps with reporting.
*/


@interface ABPerson (BIAdditions)
- (id)valueForKey:(NSString *)aKey;

- (NSComparisonResult)compareDerivedName:(ABPerson *)aPerson;
- (NSString *)derivedName;

- (NSString*)firstName;
- (NSString*)middleName;
- (NSString*)lastName;
- (NSString*)prefix;
- (NSString*)suffix;
- (NSString*)nickName;

- (NSString*)phoneticFirstName;
- (NSString*)phoneticMiddleName;
- (NSString*)phoneticLastName;


- (NSString*)fullName;
- (NSString *)company;

// includes prefix, middlename, suffix
- (NSString*)formalFullName;

- (NSDictionary *)address;
- (NSString *)primaryAddressAsString;
- (NSAttributedString *)primaryAddressAsAttributedString;
- (NSString *)primaryAddressFirstLine;
- (NSString *)remainderOfPrimaryAddressAsOneLine;

- (NSArray *)addressDictionaries;
- (NSArray *)emailDictionaries;
- (NSArray *)phoneDictionaries;

- (NSString *)primaryStreet;
- (NSString *)primaryCity;
- (NSString *)primaryState;
- (NSString *)primaryPostalCode;
- (NSString *)primaryCountry;

- (NSString *)jobTitle;
- (NSString *)department;
- (NSString *)primaryEmail;
- (NSString *)primaryWebAddress;
- (NSString *)primaryPhone;

- (BOOL)isCompany;

- (NSString *)nameTitleCompanyAddress;
- (NSString *)titleCompany;

- (void)populateBusinessIdentityIntoDefaults:(MCUserDefaults *)defs;

#ifdef BILLINGS_PRO
- (void)populateBusinessInfoIntoIdentity:(BIIdentity *)ident;
#endif

@end
